//------------------------------------------------------------------
// i8090.h header file
// v1.0 6/20/2001                                             
//------------------------------------------------------------------
//-------------- define parameter ----------------------------------
#define YES    1
#define NO     0
#define ON     1
#define OFF    0 

#define X_axis          1
#define Y_axis          2
#define Z_axis          3

#define ENC_QUADRANT    0x00
#define ENC_CW_CCW      0x10
#define ENC_PULSE_DIR   0x20
//-------------- subroutines --------------------------------------- 
extern unsigned char i8090_REGISTRATION(unsigned char cardNo, unsigned int address);
extern void          i8090_INIT_CARD(unsigned char cardNo,
                                     unsigned char x_mode,
				     unsigned char y_mode,
				     unsigned char z_mode);
extern unsigned int  i8090_GET_ENCODER(unsigned char cardNo, unsigned char axis);
extern void          i8090_RESET_ENCODER(unsigned char cardNo, unsigned char axis);
extern unsigned char i8090_GET_INDEX(unsigned char cardNo);                  
//-------------- 32 bits encoder ----------------------------------- 
extern void i8090_ENCODER32_ISR(unsigned char cardNo);
extern void i8090_RESET_ENCODER32(unsigned char cardNo, unsigned char axis);
extern long i8090_GET_ENCODER32(unsigned char cardNo, unsigned char axis);

